# 项目五 Kettle的初步使用

## 项目要求

对 Kettle的认识了解，并能初步使用。

## 学习目标：

（1）认识Kettle的特点；

（2）基本的Kettle使用知识；

（3）掌握Kettle的第一个案例。

## 相关知识

Spoon是Kettle的集成开发环境，它基于标准部件工具包（Standard Widget Toolkit，SWT）提供了图形化的用户接口，主要用于ETL的设计。在Kettle安装目录下，有启动Spoon的脚本，如Windows下的spoon.bat，类UNIX操作系统下的spoon.sh。Windows用户还可以通过执行Kettle.exe启动Spoon。

### 1.Kettle的设计原则如下

（1）易于开发：作为一个数据仓库和ETL的开发设计者，创建商务智能系统解决方案是其最终目的，而任何软件工具的安装、配置都非常耗费时间。Kettle就避免了这类问题的发生。

（2）避免自定义开发：我们只用ETL工具，目的当然是使复杂的事情变简单，使简单的事情更简单。Kettle提供了标准化的构建组件来实现设计者不断重复的需求。虽然Java代码和JavaScript脚本功能强大，但是每增加一行代码都将增加项目的复杂度和维护成本。因此，我们应尽量使用已提供的各种组件的组合来完成任务，尽量避免手动开发。

（3）用户界面完成所有功能：在Kettle里，功能的开发通过可视化界面实现，通过对话框设置组件的属性，大大缩短了开发周期。当然也有几个例外，如kettle.properties和shared.xml文件需要手动修改配置文件。

（4）命名不限制：作业、转换、步骤的名称都可以自描述，减少文档的需求。

（5）运行状态透明化：了解ETL过程的各个部分的运行状态很重要，可加快开发速度，减少维护成本。

（6）数据通道灵活：Kettle里数据的发送、接收方式比较灵活，可以从文本、Web、数据库等不同目标之间复制和分发数据，还可以合并来自不同数据源的数据。

（7）只映射需要映射的字段：Kettle的一个重要核心原则就是在ETL流动中所有未指定的字段自动被传递到下一个组件，无须一一设置输入和输出映射，输入的字段自动出现在输出中，除非中间过程特别设置了终止某个字段的传递。

前一章节，我们介绍了Kettle工具的安装。本章首先介绍Kettle工具的特点，然后介绍Kettle转换的基本概念，最后通过一个转换实操案例介绍Kettle工具的使用。

### 2.Kettle的使用

### （1）转换的基本概念

转换是Kettle ETL（Extract Transform Load）解决方案中最主要的部分，它负责处理抽取、转换、加载各阶段数据。转换包括一个或多个步骤，如读取文件、过滤输出行、数据清理、将数据加载到数据库等。

转换中的步骤通过跳来连接，跳定义了一个单向通道，允许数据从一个步骤向另一个步骤流动。在Kettle里，数据的单位是行，数据流就是数据行从一个步骤到另一个步骤的移动。数据流的另一个同义词就是记录流。除了步骤和跳，转换还包括注释。注释是一个小的文本框，可以放在转换流程图的任何位置。注释的主要目的是使转换文档化。

下图显示了一个简单的转换例子，该转换从数据库中读取数据并写入Microsoft Excel表格。

![img](./pic/图片1.png) 

### （2）步骤

步骤是转换中的基本组成部分。它是一个图形化的组件，我们可以通过配置步骤的参数，使它完成相应的功能。图3-1的例子显示了两个步骤，分别为“表输入”和“Microsoft Excel输出”。配置“表输入”步骤的参数，可以使这个步骤从指定的数据库中读取指定关系表的数据；配置“Microsoft Excel 输出”步骤的参数，可以使这个步骤向指定的路径创建一个Excel表格，并写入数据。当这两个步骤用跳（箭头连接线）连接起来的时候，“表输入”步骤读取的数据，通过跳，传输给了“Microsoft Excel 输出”步骤。最终，“Microsoft Excel 输出”步骤把“表输入”所读取的数据，写入Excel表格中。这个跳，对“表输入”而言，是个输出跳；对“Microsoft Excel输出”而言，是个输入跳。

一个步骤有如下几个关键特性。

（a）步骤需要有一个唯一的名字。

（b）每个步骤都会读、写数据行（唯一例外是“生成记录”步骤，该步骤只写数据）。

（c）步骤之间通过跳进行数据行的单向传输。一个跳，相对于输出数据的步骤而言，为输出跳；相对于输入数据的步骤而言，为输入跳。

（d）大多数的步骤都可以有多个输出跳。一个步骤的数据发送可以被设置为轮流发送和复制发送。轮流发送是将数据行依次发给每一个输出跳，复制发送是将全部数据行发送给所有输出跳。

（e）在运行转换时，一个线程运行一个步骤，所有步骤的线程几乎同时运行。数据行通过跳，依照跳的箭头图形所示，从一个步骤连续地传输到另外一个步骤。

除了具备上面这些共性功能，每个步骤都有明显的功能区别，这可以通过步骤类型体现。图3-1中的“表输入”步骤就是向关系型数据库的表发出一个SQL查询，并将得到的数据行写到它的输出跳；“Microsoft Excel 输出”步骤从它的输入跳读取数据行，并将数据行写入Excel文件。

### （3）转换的跳

转换的跳就是步骤之间带箭头的连线，跳定义了步骤之间进行数据传输的单向通道。

从程序执行的角度看，跳实际上是两个步骤线程之间进行数据行传输的缓存。这个缓存被称为行集，行集的大小可以在转换的设置里定义。当行集满了，向行集写数据的步骤将停止写入，直到行集里又有了空间。当行集空了，从行集读取数据的步骤停止读取，直到行集里又有可读的数据行。

> 注意：  因为在转换里每个步骤都依赖前一个步骤获取字段值，所以当创建新跳的时候，跳的方向是单向的，不能是双向循环的。

对Kettle的转换，从程序执行的角度看，不可能定义一个执行的顺序，也不可能确定一个起点步骤和终点步骤。因为所有步骤都以并发方式执行：当转换启动后，所有步骤都同时启动。每个步骤从它的输入跳中读取数据，并把处理过的数据写到输出跳，直到输入跳里不再有数据，就中止步骤的运行。当所有的步骤都中止了，整个转换就中止了。

同时，从功能的角度来看，转换有明确的起点步骤和终点步骤。例如，图3-1里显示的转换起点就是“表输入”步骤（因为这个步骤生成数据行）。终点就是“Microsoft Excel 输出” 步骤（因为这个步骤将数据写入文件，而且后面不再有其他节点）。

综上所述，我们可以看到：一方面，数据沿着转换里的步骤移动而形成一条从头到尾的数据通路；另一方面，转换里的步骤几乎是同时启动的，所以不可能判断出哪个步骤是第一个启动的步骤。

如果想要一个任务沿着指定的顺序执行，可以去查阅一下Kettle中“作业”的概念及使用，限于篇幅，本书不再对此内容进行介绍。

### （4）数据行

数据以数据行的形式沿着步骤移动。一个数据行是零到多个字段的集合。字段包括下面几种数据类型。

（a）String：字符类型数据。

（b）Number：双精度浮点数。

（c）Integer：带符号长整型（64位）。

（d）Bignumber：任意精度数值。

（e）Date：带毫秒精度的日期时间值。

（f）Boolean：取值为true和false的布尔值。

（g）Binary：为二进制字段，可以包括图形、声音、视频及其他类型的二进制数据。

每个步骤在输出数据行时都有对字段的描述，这种描述就是数据行的元数据，通常包括下面一些信息。

（a）名称：行里的字段名应该是唯一的。

（b）数据类型：字段的数据类型。

（c）长度：字符串的长度或 Bignumber类型的长度。

（d）掩码：数据显示的格式（转换掩码）。如果要把数值型（Number、Integer、Bignumber）或日期类型转换成字符串类型就需要用到掩码。例如在图形界面中预览数值型、日期型数据，或者把这些数据保存成文本或XML格式，就需要用到这种转换。

（e）小数点：十进制数据的小数点格式。不同文化背景下小数点符号是不同的，一般是点（.）或逗号（,）。

（f）分组符号：数值类型数据的分组符号，不同文化背景下数字里的分组符号也是不同的，一般是逗号（,）、点（.）或单引号（'）。（注：分组符号是数字里的分割符号，便于阅读，如123,456,789）

（g）初始步骤： Kettle在元数据里还记录了字段是由哪个步骤创建的。可以让用户快速定位字段是由转换里的哪个步骤最后一次修改或创建的。

当设计转换时有3个数据类型的规则需要注意。

（a）行级里的所有行都应该有同样的数据结构。也就是说，当从多个步骤向一个步骤里写数据时，多个步骤输出的数据行应该有相同的结构，即字段相同、字段数据类型相同、字段顺序相同。

（b）字段元数据不会在转换中发生变化。也就是说，字符串不会自动截去长度以适应指定的长度，浮点数也不会自动取整以适应指定的精度。这些功能必须通过一些指定的步骤来完成。

（c）在默认情况下，空字符串（""）被认为与NULL相等。

## 操作步骤

第一个转换案例

Kettle使用图形化的方式定义复杂的ETL程序和工作流，所以被归类为可视化编程语言。利用Kettle，我们可以快速构建复杂的ETL作业和降低维护工作量。由于Kettle通过组件的配置，隐藏了很多技术细节，使IT领域更贴近商务领域。

本节将介绍如何利用Kettle的可视化编程，实现数据转换。

由于本案例要从MySQL数据库中读取表格内容并输出到Excel表格，还需要一个额外的jar包支持。该jar包可在MySQL的官方网站进行下载，此处使用的jar包版本为5.1.45。下载完毕后，解压压缩包，将mysql-connector-java-5.1.46-bin.jar文件存放到\data-integration\lib\路径下。然后，关闭Kettle后再次打开Kettle，使该jar包生效。该jar包生效后，可在“表输入”步骤中配置MySQL数据库客户端连接到服务端的参数，连接到相关的数据库，获取相关的表格数据并输出到Excel表格中。

在此案例中，由于需要从MySQL数据库获取表格数据，因此，需要读者预先安装MySQL服务端与客户端，通过客户端创建数据库与表并输入数据。

### 步骤1：创建转换

运行Spoon.bat后，Kettle将启动Spoon，进入可视化编程界面。启动完毕后的界面如图所示。

![img](./pic/图片2.png) 

在Spoon界面的快捷工具栏中单击![img](./pic/xt-1.png)按钮，在下拉菜单中选择“转换”命令，这样创建了一个转换文件。

![img](./pic/图片3.png) 

> 注意：“作业”包括一个或多个作业项，作业项由转换构成。 

单击“![img](./pic/xt-2.png)”按钮，重命名该转换文件，设置保存路径，最后单击“保存(S)”按钮，如下图所示。

![img](./pic/图片4.png) 

单击“保存(S)”按钮

![img](./pic/图片5.png) 

窗口中空白的地方被称为空画布。可以在这个空画布上进行可视化编程。

![img](./pic/图片6.png) 



### 步骤2：核心对象

如图所示，“核心对象”选项卡位于Spoon的左上角，在“主对象树”选项卡的右边。

![img](./pic/图片7.png)

在“核心对象”的选项卡中，以文件夹的方式存放了各种类型的步骤，单击某个文件夹即可展开该文件夹里面所有的步骤。ETL工程师可以根据设计的需求，选择合适的步骤，按住鼠标左键，拖曳选定的步骤到画布中使用。

也可在左上角的“步骤”搜索框中，输入步骤的大体名称，进行模糊查找。查找的结果中将显示符合查找条件的步骤位于哪个文件夹下。这样，ETL工程师可以选择合适的步骤，按住鼠标左键，拖曳选定的步骤到画布中使用。

> 注意：在核心对象中的步骤上双击鼠标左键，该步骤将出现在右边的画布中，并自动连接上一个步骤。

### 步骤3：可视化编程

（a）创建步骤

在“核心对象”对象卡中单击“输入”文件夹展开输入类型的所有步骤。按住鼠标左键拖曳“表输入”步骤到画布中。这样，在画布中就创建了一个新步骤。

![img](./pic/图片8.png) 

在“核心对象”选项卡中，单击“输出”文件夹展开输出类型的所有步骤。单击“Microsoft Excel输出”步骤，按住鼠标左键拖曳到画布中。

![img](./pic/图片9.png) 

（b）创建转换的跳，连接步骤

转换里的步骤通过跳定义一个单向通道来连接。单击“表输入”步骤，按住鼠标左键，将箭头一直拖到“Microsoft Excel 输出”，待箭头变成绿色时，松开鼠标左键，即可建立两个步骤之间的跳，如图所示。

![img](./pic/图片10.png) 

> 注意： 在跳的箭头符号单击鼠标右键，在弹出的快捷菜单栏中选择相关的操作，就可以设置该跳的一些属性，包括“使节点连接时效”和“删除节点连接”等。

（c）配置“表输入”步骤

① 双击“表输入”步骤进行配置，在弹出的配置对话框中单击“新建…”按钮配置数据库的连接信息。

![img](./pic/图片11.png) 

② 首先，给连接名称任意起个名字，在这里命名为“sql_testlink”，然后进行如下设置。

![img](./pic/图片12.png) 

“连接类型”选择MySQL，因为我们需要连接到MySQL数据库。

“主机名称”为MySQL服务端的IP，如果Kettle和MySQL服务端都安装在同一PC中，则配置为localhost。

“数据库名称”为MySQL服务端的数据库，需要在MySQL客户端上提前创建好。这里的配置为“sql_test”。

“端口号”的配置为默认的端口。

输入MySQL登录的用户名和密码。

③ 单击“测试”按钮，如果参数正确，系统将弹出提示正确连接到数据库的对话框。至此，数据库的连接配置已完成。

④ 单击“数据库连接测试”对话框中的“确定”按钮，关闭此对话框。单击“数据库连接”对话框中的“确定”按钮，关闭“数据库连接”对话框。

此时，界面将回退到“表输入”对话框的配置界面。“表输入”对话框中的“数据库连接”下拉栏目中会显示刚刚配置的连接名称“sql_testlink”。

![img](./pic/图片13.png) 

> 注意：如果需要修改数据库连接信息，可以单击“编辑”按钮，在打开的对话框中进行修改。 

⑤ 在“表输入”对话框中单击“获取SQL语句…”按钮，系统将弹出“数据库浏览器”。

![img](./pic/图片14.png) 

![img](./pic/图片15.png) 

⑥ 单击![img](file:///C:\Users\Administrator\AppData\Local\Temp\ksohtml15872\wps26.jpg)依次展开“sql_testlink”和“表”，然后双击该数据库中的“学生”表，在弹出的对话框中单击“是(Y)”按钮。

![img](./pic/图片16.png) ![img](./pic/图片17.png)

此时，界面回退到“表输入”对话框。在此对话框的SQL文本框中，显示从数据表中抽取数据的SQL语句。

![img](./pic/图片18.png) 

⑦ 单击“预览(P)”按钮。

![img](./pic/图片19.png) 

⑧ 在打开的对话框中输入预览的记录数量如1000，单击“确定(O)”按钮后，将可以查看学生表的数据记录信息。此时，我们已完成“表输入”步骤的配置。

![img](./pic/图片20.png) 

![img](./pic/图片21.png) 

（d）配置“Microsoft Excel 输出”步骤

① 双击“Microsoft Excel 输出”步骤，在打开的配置对话框中单击“文件&工作表”选项卡进行配置。

② 单击图中的“浏览(B)…”按钮，配置输出的文件路径、文件名。

![img](./pic/图片22.png)

③ 单击“扩展名”的![img](./pic/xt-9.png)按钮，选择输出的文件类型，一般配置Excel 2007及以上版本的表格输出。

④ 在“Microsoft Excel 输出”步骤的配置对话框中，单击选定“内容”进行配置。

⑤ 如图所示，单击“获取字段”按钮，获取上个步骤输出的数据字段。

获取后，在“字段”的表格中显示已获取的字段，如图所示。这些字段将在C:\Users\45812\
Desktop\etl\ktr\outfile.xlsx文件中输出，路径中的“45812”为本机器的Windows用户名。

![img](./pic/图片23.png) 

![img](./pic/图片24.png) 

（5）运行转换

单击![img](./pic/xt-10.png)开始运行程序，在弹出的对话框中，单击![img](./pic/xt-11.png)按钮运行该程序。

![img](./pic/图片25.png) 

### 步骤4：执行结果

执行完毕后，输出的文件被保存在“Microsoft Excel 输出”步骤设置的路径下。该转换的输出路径及文件为C:\Users\45812\Desktop\etl\ktr\outfile.xlsx

![img](./pic/图片26.png) 

对Kettle而言，执行的一系列结果在右下方的“执行结果”状态栏中显示。也就是说，“执行结果”状态栏是对转换、作业执行过程的监控。

“日志”选项卡展示了该转换的时间执行过程。如果程序运行出错，这里将显示具体的出错信息，设计者可根据错误信息调试程序。

![img](./pic/图片27.png) 

“步骤度量”选项卡，“Metrics”选项卡，它们都展示了该转换执行过程中每一个步骤所耗费的时间。设计者可根据这些信息对所设计的转换进行优化，提升转换执行的效率。

![img](./pic/图片28.png) 

![img](./pic/图片29.png) 

此外，“步骤度量”还展示了数据在每一个步骤的输入/输出流程，设计者可根据这些信息核实数据的流程是否符合预定的设计流程。

“Preview data”选项显示该转换中鼠标已选定步骤的输出结果。

![img](./pic/图片30.png) 

### 步骤5：状态栏

状态栏显示了一系列调试运行程序的按钮。

![img](./pic/图片31.png) 

![img](./pic/xt-3.png)：运行程序。可通过下拉的三角符号选择运行的选项。

![img](./pic/xt-4.png)：暂停正在运行的程序。

![img](./pic/xt-5.png)：终止正在运行的程序。

![img](./pic/xt-6.png)：按上一次的执行选项重新执行此程序。

![img](./pic/xt-7.png)：预览/调试程序。设定调试的条件后，单击“配置”按钮进入调试模式。

例如，调试学生编号为1的配置如图所示。

![img](./pic/图片32.png) 

### 步骤6：主对象树

在进行可视化编程的过程中，在画布上每增添一个步骤、一个跳等，系统都会在主对象树中记录并呈现出来。设计者在检查程序设计时，可以在主对象树中双击相关的对象进行编辑修改，实现对程序的调试。

![img](./pic/图片33.png) 

### 步骤7：参数配置

Kettle的参数配置分为环境变量配置和命名参数两类。环境变量具有全局性质，配置后的环境变量对所有转换、作业都可用、有效；命名参数具有局部性质，仅对当前转换、作业有效。

（a）环境变量配置

环境变量的配置路径及文件为C:\Users\45812\.kettle\kettle.properties（45812表示此Windows下的用户）。用文本编辑器Visual Studio Code打开kettle.properties文件，即可用键值对的形式配置环境变量。一个环境变量占一行，键在等号前面，作为配置所使用的环境变量名，等号后面就是这个环境变量的值。转换和作业可以通过“${环境变量名}”或“%%环境变量名%%”的方式来引用kettle.properties定义的环境变量。

如下图所示是基于第一个转换实验的配置例子，配置“Microsoft Excel 输出”步骤中的输出路径，用环境变量“GLOBAL_PATH”表示。配置kettle.properties完毕后，需要关闭Kettle再重新打开，选择配置的全局参数才生效可用。

![img](./pic/图片34.png)

如下图所示，在“Microsoft Excel 输出”步骤的配置中，用“${ GLOBAL_PATH }”引用环境变量，指定输出的路径为C:/Users/45812/Desktop/etl/GlobalPath。

![img](./pic/图片35.png)

当创建同样的第二个转换后，该全局参数同样可为第二个转换所用。

（b）命名参数配置

在当前转换画布上空白的地方单击鼠标右键，在弹出的快捷菜单中选择“转换设置CTRL-L”命令。

![img](./pic/图片36.png) 

在“转换属性”的“命名参数”选项卡中配置命名参数的名字和值。

![img](./pic/图片37.png) 

配置后，即可在该转换中使用此命名参数。使用命名参数，使输出文件localoutfile保存在命名参数指定的路径C:\Users\45812\Desktop\etl\LocalPath下。

![img](./pic/图片38.png) 



## 项目总结：

本项目对 Kettle的特点、使用知识进行了介绍，并举Kettle的第一个案例，让同学们能够理论与实践结合，初步学习Kettle的方方面面。

## 作业练习：

1.什么是转换？

2.Kettle的参数配置分为哪两类，并简述每一类的作用范围。

3.一个步骤有哪几个关键特性？

4.什么是跳？

5.实操练习：使用Kettle读取 CSV 文件，并实现CSV文件转换成Excel文件。